;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   AUTOCAD-MAGAZIN-Tool-CD-Commander
;;;
;;;               Version 1.05
;;;
;;; von Boran Ggetap, uniVirtual pictures (uVp)
;;;       - alle Rechte vorbehalten -
;;;
;;;     exklusiv fr das AUTOCAD MAGAZIN
;;;
;;

;(setq n (findfile "amsdtool.lsp"))

;    (if (AND (= (type n) 'STR) 
;  	     (= "AMSDTOOL.LSP" (strcase (substr n (- (strlen n) 11)))))
;	      (setq am_sdroot (substr n 1 (- (strlen n) 13)))
;    );ende if

;    (if (= n nil) (setq am_sdroot "A:"))

;*************************** Hauptprogramm *********************************

(defun c:am ()

  (setq n (findfile "amsdtool.lsp"))
   (setq am_sdroot (substr n 1 (- (strlen n) 13)))

    (if (null am_verzeichnis)

        (load (strcat am_sdroot "\\" "gesamt.lst"))
    );end if

    (if (null am_dcl_id)
      (setq am_dcl_id (load_dialog (strcat am_sdroot "\\" "amsdtool.dcl")))
    );end if

(am:initdialog)

;; zuletzt geladene Befehle wieder setzen:

    (if am_kommando_text
     (progn

  (am:ladebefehle)
   (set_tile "status" (strcat "Bitte starten Sie '"am_kommando_text

    (if (cdr am_befehle) "' / ..." "'")

  " erneut oder whlen Sie einen anderen Artikel."))

    );end progn

(mode_tile "artikel" 2)

   );end if

   (while (= (setq am_return (start_dialog)) 55)
	(am:weiterladen)
	(am:initdialog)
	(am:holbefehle)
   );end while

    (cond
      ((= am_return  33) (eval am_kommando))
      ((= am_return 333) (command am_kommando))
    )
(princ)
);end defun c:

;********************* Artikelverzeichnis in Listbox laden ***************

(defun am:initdialog ()

(new_dialog "haupt" am_dcl_id)
 (start_list "artikel" 3)

   (foreach artikel am_verzeichnis
            (add_list (strcat (cadr artikel) "\t" (car artikel)))
   );end foreach

(end_list)

    (if am_letzter_artikel
     (progn

      (set_tile "artikel" am_letzter_artikel)
       (on_artikel am_letzter_artikel 1)

     );end progn
    );end if

);end defun

;********************* Handler fr die Artikelbersicht ******************

(defun on_artikel (wert grund)

    (if (= grund 1) ;SELECT
     (progn
      (am_alle_buttons_aus)

 (setq artikel (nth (read wert) am_verzeichnis)
               am_ausgabe (nth 1 artikel)
               am_subdir (nth 2 artikel)
               am_artikel (nth 3 artikel)
               am_quelle (nth 4 artikel)
               am_letzter_artikel wert)
	
    (if (am:ladetext 
     (strcat am_sdroot "\\" am_ausgabe "\\" am_subdir "\\" am_artikel))

     (progn

      (if (> (strlen am_quelle) 0)
       (progn
   (set_tile "status" (strcat "Das Programm zu diesem Artikel knnen Sie Laden, Anzeigen" 
" lassen oder De-Installieren."))

(mapcar '(lambda (tile) (mode_tile tile 0)) '("lesen" "deinstallieren" "laden"))

     );end progn

     (progn
      (set_tile "status" "Zu diesem Artikel gibt es kein Lisp-Programm.
                          Bitte lesen Sie die Beschreibung!")

(mapcar '(lambda (tile) (mode_tile tile 0)) '("deinstallieren"))

     );end progn
    );end if
			
;    (if (setq am_temp (open 
;        (strcat am_sdroot "\\" am_ausgabe "\\" am_subdir "\\" "install.txt") "r"))

;     (progn
;      (mode_tile "installieren" 0)
;       (close am_temp)
;     );end progn
;    );end if
   );end progn

     (progn
      (start_list "beschreibung")
       (add_list "")
        (add_list "")
         (add_list "\t Dieser Artikel ist auf Ihrem System nicht installiert -")
          (add_list "")
(add_list "\tWenn Sie den Artikel auf Diskette haben, whlen Sie INSTALLIEREN,")
(add_list "\twenn Sie den Artikel nachbestellen mchten, whlen Sie BESTELLEN.")
(end_list)
(mapcar '(lambda (tile) (mode_tile tile 0)) '("installieren" "bestellen"))

(set_tile "status" "Bitte whlen Sie INSTALLIEREN oder BESTELLEN, oder whlen Sie
                    einen anderen Artikel.")

    );end progn
   );end if
  );end progn
 );end if

);end defun

;******************** weitere Handler fr Buttons **********************

(defun on_suchen ()

	(alert "Funktion noch nicht implementiert...")

);end defun

;************************ Quelltext lesen ******************************

(defun on_lesen ()

    (if (am:ladetext 
     (strcat am_sdroot "\\" am_ausgabe "\\" am_subdir "\\" am_quelle ))
T
     (progn
      (start_list "beschreibung")
       (add_list "-nicht installiert-")
        (end_list)

     );end progn
    );end if

);end defun

;************************************************************************

(defun on_installieren ()

    (if (am:ladetext 
     (strcat am_sdroot "\\" am_ausgabe "\\" am_subdir "\\install.txt"  ))
T
     (progn

 (start_list "beschreibung")
  (add_list "")
   (add_list "\tZum Installieren kopieren Sie die Service-Disk Ausgabe")
    (add_list "")
     (add_list (strcat "\t\t" am_ausgabe))
      (add_list "")
       (add_list "\t mit allen Unterverzeichnissen in das Verzeichnis")
        (add_list "")
         (add_list (strcat "\t\t" (strcase am_sdroot)))
          (end_list)

     );end progn
    );end if

);end defun

;************************************************************************

(defun on_deinstallieren ()

 (start_list "beschreibung")
  (add_list "")
   (add_list "\t Zum De-Installieren lschen Sie das Verzeichnis:")
    (add_list "")
     (add_list "")
      (add_list (strcat "\t" (strcase am_sdroot) "\\" am_ausgabe "\\" am_subdir))
       (end_list)

);end defun

;**************************************************************************

(defun on_bestellen ( / bestellen)

 (setq find (strcat am_sdroot "\\" "INFODATEIEN" "\\" "bestell.txt"))
  (startapp "notepad" find)

);end defun

;*******************************************************************************

(defun on_laden ()

(setq am_zuladen 
      (strcat am_sdroot "\\" am_ausgabe "\\" am_subdir "\\" am_quelle))

	;; Protected-Lisp-Programme knnen nicht geladen werden,
	;; wenn Dialogboxen geffnet sind,
	;; und auch einige andere Lispausdrcke vertragen sich nicht
	;; mit offenen Dialogen
	;;
(done_dialog 55)

);end defun

;*******************************************************************************

(defun on_hilfe ()

(am:ladetext (strcat am_sdroot "\\" "INFODATEIEN" "\\" "amshilfe.txt"))

);end defun

;*************************************************************************

(defun on_info ()

	(am:ladetext (strcat am_sdroot "\\" "INFODATEIEN" "\\" "amsdinfo.txt"))

);end defun

;************************************************************************

(defun am:weiterladen ()
   (cond
     ((=(strcase (substr am_zuladen (- (strlen am_zuladen) 3))) ".EXE")
       (if(= (xload am_zuladen "laden_nicht_geklappt") "laden_nicht_geklappt")
	 (alert "EXE-Programm konnte nicht geladen werden!")
	 'T
       )
     )  
     ((=(strcase (substr am_zuladen (- (strlen am_zuladen) 3))) ".DLL")
       (command "NETLOAD" am_zuladen)
      'T
     )
     ('T
       (if(= (load am_zuladen "laden_nicht_geklappt") "laden_nicht_geklappt")
         (alert "Lisp-Programm konnte nicht geladen werden!")
         'T
       )	
     )
  )
)

;**********************************************************************

(defun am:holbefehle ()

    (if (setq am_befehle (nth 5 artikel))
     (progn

      (set_tile "status" "Programm wurde erfolgreich geladen.")

(am:ladebefehle)

);end progn

     (progn
      (set_tile "status" "Dieses Programm enthlt keine 'C:...'-Befehle -                                                                              Bitte lesen Sie die Beschreibung!")

     );end progn
    );end if

);end defun

;**************************************************************************

(defun am:ladebefehle ()

 (mode_tile "starten" 0) ; = aktiv ...
  (mode_tile "starten" 2) ; = ... und fokussiert
   (start_list "starten")
    (add_list "Starten...")

   (foreach einbefehl am_befehle
            (add_list einbefehl)

   );end foreach

(end_list)

);end defun

;************************************************************************

(defun on_starten (wert grund )
  (if (= grund 1)
    (progn
      (setq am_kommando_text (nth (if (= wert "0") 0 (1- (read wert))) am_befehle))
      (princ (strcat "\nFhre aus: " am_kommando_text))

      (cond
	((and(=(type (read am_kommando_text))'LIST)
	     (=(car (read am_kommando_text))"NET")
	     (=(type(setq am_kommando (cadr (read am_kommando_text))))'STR)
	 )
	 (done_dialog 333)
	)
	((/= 'LIST (type (read am_kommando_text)))
  	  (setq am_kommando (read (strcat "(C:" am_kommando_text ")" )))
	  (done_dialog 33)
	)
	('T (setq am_kommando (read am_kommando_text))(done_dialog 33))
      )	
    )
  )
)

;************************ weitere Hilfsfunktionen ***********************

(defun am_alle_buttons_aus ()

(mapcar '(lambda (tile) (mode_tile tile 1))
        '("lesen" "installieren" "deinstallieren" "bestellen" "laden" "starten") )

);end defun

;*************************************************************************

(defun am:ladetext ( dateiname )
	
    (if (setq beschreib_txt (open dateiname "r"))
     (progn
      (start_list "beschreibung")

(setq am_rest_zeile ""
      am_maxzeile 120
      add_zeile "")

   (while (setq beschreib_zeile (read-line beschreib_txt))

    (while (> (strlen beschreib_zeile) am_maxzeile)
           (setq am_trenner am_maxzeile)

     (while (> am_trenner 1)

    (if (= (substr beschreib_zeile am_trenner 1) " " )
     (setq am_trenner (- 0 am_trenner))
      (setq am_trenner (1- am_trenner))
    );end if
   );end while am_trenner

    (if (= am_trenner 1)
     (setq am_trenner am_maxzeile)
      (setq am_trenner (- 0 am_trenner ))
    );end if

(setq rohzeile (substr beschreib_zeile 1 am_trenner)
      beschreib_zeile (substr beschreib_zeile (1+ am_trenner)))
(add_list rohzeile)

   );end while am_maxzeile

; den Rest auch noch:
(add_list beschreib_zeile)

);end  while setq

(end_list)
(close beschreib_txt)

T

     );end progn

nil

    );if Datei offen

);end defun

;********************************************************************

(defun c:rl ()

 (setq am_verzeichnis nil)
  (load (strcat am_sdroot "\\" "amsdtool" ))

);end defun

;*********************************************************************

(princ "\nAUTOCAD-MAGAZIN-Commander geladen. Starten mit 'AM'.")
;(C:AM)
(princ)
